/*
 * Decompiled with CFR 0.152.
 */
package eu.tznvy.jancy.transpiler;

import eu.tznvy.jancy.core.Playbook;
import eu.tznvy.jancy.core.PlaybookFactory;
import eu.tznvy.jancy.transpiler.argparsing.Args;
import eu.tznvy.jancy.transpiler.argparsing.ArgsParser;
import eu.tznvy.jancy.transpiler.argparsing.PrintUsageArgs$;
import eu.tznvy.jancy.transpiler.argparsing.PrintVersionArgs$;
import eu.tznvy.jancy.transpiler.argparsing.TranspileArgs;
import eu.tznvy.jancy.transpiler.discovery.ContentFile;
import eu.tznvy.jancy.transpiler.discovery.ContentFilesDiscoverer$;
import eu.tznvy.jancy.transpiler.discovery.ContentFilesExtractor;
import eu.tznvy.jancy.transpiler.discovery.JarClassSource;
import eu.tznvy.jancy.transpiler.discovery.PlaybookFactoriesDiscoverer$;
import eu.tznvy.jancy.transpiler.helpers.ConcreteFilesystem;
import eu.tznvy.jancy.transpiler.rendering.PlaybookRenderer;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import resource.ExtractedEither;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;

public final class Main$ {
    public static Main$ MODULE$;
    private final String executableName;
    private final String version;

    static {
        new Main$();
    }

    private String executableName() {
        return this.executableName;
    }

    private String version() {
        return this.version;
    }

    public void main(String[] args) {
        ArgsParser argParser = new ArgsParser(this.executableName());
        argParser.tryParse(args).map((Function1<Args, Object> & Serializable & scala.Serializable)x0$1 -> {
            Serializable serializable;
            Args args = x0$1;
            if (args instanceof TranspileArgs) {
                TranspileArgs transpileArgs = (TranspileArgs)args;
                serializable = BoxesRunTime.boxToBoolean(this.transpile(transpileArgs));
            } else if (PrintVersionArgs$.MODULE$.equals(args)) {
                serializable = BoxesRunTime.boxToBoolean(this.printVersion());
            } else if (PrintUsageArgs$.MODULE$.equals(args)) {
                argParser.printUsage();
                serializable = BoxedUnit.UNIT;
            } else {
                throw new MatchError(args);
            }
            return serializable;
        }).getOrElse((JFunction0$mcV$sp & scala.Serializable)() -> System.exit(1));
    }

    public boolean transpile(TranspileArgs args) {
        ConcreteFilesystem filesystem = new ConcreteFilesystem();
        PlaybookRenderer playbookRenderer = new PlaybookRenderer(filesystem);
        ContentFilesExtractor contentFilesExtractor = new ContentFilesExtractor(filesystem);
        ExtractedEither maybePlaybookFactories = package$.MODULE$.managed((Function0<JarClassSource> & Serializable & scala.Serializable)() -> new JarClassSource(args.jar()), Resource$.MODULE$.closeableResource(), ClassManifestFactory$.MODULE$.classType(JarClassSource.class)).map((Function1<JarClassSource, Seq> & Serializable & scala.Serializable)x$1 -> PlaybookFactoriesDiscoverer$.MODULE$.findPlaybookFactories((JarClassSource)x$1, args.classname())).either();
        if (package$.MODULE$.extractedEitherToEither(maybePlaybookFactories).isLeft()) {
            throw (Throwable)((IterableLike)package$.MODULE$.extractedEitherToEither(maybePlaybookFactories).left().get()).head();
        }
        Seq playbookFactories = (Seq)package$.MODULE$.extractedEitherToEither(maybePlaybookFactories).right().get();
        if (playbookFactories.isEmpty()) {
            String errorMessage = (String)args.classname().map((Function1<String, String> & Serializable & scala.Serializable)x$2 -> x$2 + " not found or it does not implement PlaybookFactory interface.").getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "No PlaybookFactory implementations found in the jar.");
            throw new Error(errorMessage);
        }
        Seq playbooks = playbookFactories.map((Function1<PlaybookFactory, Tuple3> & Serializable & scala.Serializable)pbf -> {
            Playbook playbook = pbf.build();
            Path outputPath = Paths.get(args.output().getPath(), playbook.getName());
            Seq<ContentFile> contentFiles = ContentFilesDiscoverer$.MODULE$.discover(args.jar(), playbook.getName());
            return new Tuple3<Playbook, Path, Seq<ContentFile>>(playbook, outputPath, contentFiles);
        }, Seq$.MODULE$.canBuildFrom());
        playbooks.foreach((Function1<Tuple3, Seq> & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Playbook playbook = (Playbook)tuple3._1();
            Path outputPath = (Path)tuple3._2();
            Seq contentFiles = (Seq)tuple3._3();
            playbookRenderer.render(playbook, outputPath);
            Seq<Path> seq = contentFilesExtractor.extract(contentFiles, args.jar(), outputPath);
            return seq;
        });
        return true;
    }

    public boolean printVersion() {
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.executableName(), this.version()})));
        return true;
    }

    private Main$() {
        MODULE$ = this;
        this.executableName = "jancy";
        this.version = "0.1.0-SNAPSHOT";
    }
}

