/*
 * Decompiled with CFR 0.152.
 */
package eu.tznvy.jancy.core;

import eu.tznvy.jancy.core.Action;
import eu.tznvy.jancy.core.Handler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class Tasklike<T extends Tasklike> {
    protected final Optional<Action> action;
    protected final Map<String, Object> arguments;

    protected Tasklike(String string) {
        this.arguments = new HashMap<String, Object>();
        this.arguments.put("name", string);
        this.action = Optional.empty();
    }

    protected Tasklike(Map<String, Object> map, Optional<Action> optional) {
        this.arguments = new HashMap<String, Object>(map);
        this.action = optional;
    }

    protected abstract T build(Map<String, Object> var1, Optional<Action> var2);

    protected Map<String, Object> withArgument(String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.arguments);
        hashMap.put(string, object);
        return hashMap;
    }

    public Map<String, Object> getArguments() {
        return new HashMap<String, Object>(this.arguments);
    }

    public Optional<Action> getAction() {
        return this.action;
    }

    public String getName() {
        return (String)this.arguments.get("name");
    }

    public T action(Action action) {
        return this.build(this.arguments, Optional.of(action));
    }

    public T notify(Handler ... handlerArray) {
        String[] stringArray = new String[handlerArray.length];
        for (int i = 0; i < handlerArray.length; ++i) {
            stringArray[i] = handlerArray[i].getName();
        }
        return this.build(this.withArgument("notify", stringArray), this.action);
    }

    public T notify(Object ... objectArray) {
        return this.build(this.withArgument("notify", objectArray), this.action);
    }

    public T when(String string) {
        return this.build(this.withArgument("when", string), this.action);
    }

    public T withItems(Object ... objectArray) {
        return this.build(this.withArgument("with_items", objectArray), this.action);
    }

    public T withNested(Object ... objectArray) {
        return this.build(this.withArgument("with_nested", objectArray), this.action);
    }

    public T withDict(Object ... objectArray) {
        return this.build(this.withArgument("with_dict", objectArray), this.action);
    }

    public T withFile(Object ... objectArray) {
        return this.build(this.withArgument("with_file", objectArray), this.action);
    }

    public T withFileglob(Object ... objectArray) {
        return this.build(this.withArgument("with_fileglob", objectArray), this.action);
    }

    public T withTogether(Object ... objectArray) {
        return this.build(this.withArgument("with_together", objectArray), this.action);
    }

    public T withSubelements(Object ... objectArray) {
        return this.build(this.withArgument("with_subelements", objectArray), this.action);
    }

    public T withSequence(String string) {
        return this.build(this.withArgument("with_sequence", string), this.action);
    }

    public T withRandomChoice(Object ... objectArray) {
        return this.build(this.withArgument("with_random_choice", objectArray), this.action);
    }

    public T register(String string) {
        return this.build(this.withArgument("register", string), this.action);
    }

    public T retries(String string) {
        return this.build(this.withArgument("retries", string), this.action);
    }

    public T delay(String string) {
        return this.build(this.withArgument("delay", string), this.action);
    }

    public T withFirstFound(Object ... objectArray) {
        return this.build(this.withArgument("with_first_found", objectArray), this.action);
    }

    public T withLines(String string) {
        return this.build(this.withArgument("with_lines", string), this.action);
    }

    public T withIndexedItems(Object ... objectArray) {
        return this.build(this.withArgument("with_indexed_items", objectArray), this.action);
    }

    public T withIni(String string) {
        return this.build(this.withArgument("with_ini", string), this.action);
    }

    public T withFlattened(Object ... objectArray) {
        return this.build(this.withArgument("with_flattened", objectArray), this.action);
    }

    public T withInventoryHostnames(Object ... objectArray) {
        return this.build(this.withArgument("with_inventory_hostnames", objectArray), this.action);
    }

    public T meta(String string) {
        return this.build(this.withArgument("meta", string), this.action);
    }

    public T tags(Object ... objectArray) {
        return this.build(this.withArgument("tags", objectArray), this.action);
    }

    public T changedWhen(String string) {
        return this.build(this.withArgument("changed_when", string), this.action);
    }

    public T failedWhen(String string) {
        return this.build(this.withArgument("failed_when", string), this.action);
    }

    public T ignoreErrors(boolean bl) {
        return this.build(this.withArgument("ignore_errors", bl ? "yes" : "no"), this.action);
    }

    public T delegateTo(String string) {
        return this.build(this.withArgument("delegate_to", string), this.action);
    }

    public T delegateFacts(boolean bl) {
        return this.build(this.withArgument("delegate_facts", bl ? "yes" : "no"), this.action);
    }

    public T runOnce(boolean bl) {
        return this.build(this.withArgument("run_once", bl ? "yes" : "no"), this.action);
    }
}

