/*
 * Decompiled with CFR 0.152.
 */
package eu.tznvy.jancy.core;

import eu.tznvy.jancy.core.ArraysHelper;
import eu.tznvy.jancy.core.Handler;
import eu.tznvy.jancy.core.Task;
import java.util.HashMap;
import java.util.Map;

public class Role {
    private final Handler[] handlers;
    private final String name;
    private final Task[] tasks;
    private final Map<String, Object> vars;

    public Role(String string) {
        this.handlers = new Handler[0];
        this.name = string;
        this.tasks = new Task[0];
        this.vars = new HashMap<String, Object>();
    }

    private Role(Handler[] handlerArray, String string, Task[] taskArray, Map<String, Object> map) {
        this.handlers = ArraysHelper.copyIfNotEmpty(handlerArray);
        this.name = string;
        this.tasks = taskArray;
        this.vars = new HashMap<String, Object>(map);
    }

    public Role handlers(Handler ... handlerArray) {
        return new Role(ArraysHelper.copyIfNotEmpty(handlerArray), this.name, this.tasks, this.vars);
    }

    public Role tasks(Task ... taskArray) {
        return new Role(this.handlers, this.name, ArraysHelper.copyIfNotEmpty(taskArray), this.vars);
    }

    public Role vars(Map<String, Object> map) {
        return new Role(this.handlers, this.name, this.tasks, new HashMap<String, Object>(map));
    }

    public Handler[] getHandlers() {
        return ArraysHelper.copyIfNotEmpty(this.handlers);
    }

    public String getName() {
        return this.name;
    }

    public Task[] getTasks() {
        return ArraysHelper.copyIfNotEmpty(this.tasks);
    }

    public Map<String, Object> getVars() {
        return new HashMap<String, Object>(this.vars);
    }
}

