/*
 * Decompiled with CFR 0.152.
 */
package eu.tznvy.jancy.core;

import eu.tznvy.jancy.core.ArraysHelper;
import eu.tznvy.jancy.core.Inventory;
import eu.tznvy.jancy.core.Play;
import eu.tznvy.jancy.core.Role;

public class Playbook {
    private final Inventory[] inventories;
    private final String name;
    private final Play[] plays;
    private final Role[] roles;

    public Playbook(String string) {
        this.inventories = new Inventory[0];
        this.name = string;
        this.plays = new Play[0];
        this.roles = new Role[0];
    }

    private Playbook(Inventory[] inventoryArray, String string, Play[] playArray, Role[] roleArray) {
        this.inventories = inventoryArray;
        this.plays = playArray;
        this.roles = roleArray;
        this.name = string;
    }

    public Playbook inventories(Inventory ... inventoryArray) {
        return new Playbook(ArraysHelper.copyIfNotEmpty(inventoryArray), this.name, this.plays, this.roles);
    }

    public Playbook plays(Play ... playArray) {
        return new Playbook(this.inventories, this.name, ArraysHelper.copyIfNotEmpty(playArray), this.roles);
    }

    public Playbook roles(Role ... roleArray) {
        return new Playbook(this.inventories, this.name, this.plays, ArraysHelper.copyIfNotEmpty(roleArray));
    }

    public Inventory[] getInventories() {
        return ArraysHelper.copyIfNotEmpty(this.inventories);
    }

    public String getName() {
        return this.name;
    }

    public Play[] getPlays() {
        return ArraysHelper.copyIfNotEmpty(this.plays);
    }

    public Role[] getRoles() {
        return ArraysHelper.copyIfNotEmpty(this.roles);
    }
}

