/*
 * Decompiled with CFR 0.152.
 */
package eu.tznvy.jancy.core;

import eu.tznvy.jancy.core.ArraysHelper;
import eu.tznvy.jancy.core.Handler;
import eu.tznvy.jancy.core.Hosts;
import eu.tznvy.jancy.core.Role;
import eu.tznvy.jancy.core.Task;
import java.util.LinkedList;

public class Play {
    private final Handler[] handlers;
    private final String[] hosts;
    private final String name;
    private final String[] roles;
    private final Task[] tasks;

    public Play(String string) {
        this.handlers = new Handler[0];
        this.hosts = new String[0];
        this.name = string;
        this.roles = new String[0];
        this.tasks = new Task[0];
    }

    private Play(Handler[] handlerArray, String[] stringArray, String string, String[] stringArray2, Task[] taskArray) {
        this.handlers = handlerArray;
        this.hosts = stringArray;
        this.name = string;
        this.roles = stringArray2;
        this.tasks = taskArray;
    }

    public Play handlers(Handler ... handlerArray) {
        return new Play(ArraysHelper.copyIfNotEmpty(handlerArray), this.hosts, this.name, this.roles, this.tasks);
    }

    public Play hosts(Hosts ... hostsArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Hosts hosts : hostsArray) {
            linkedList.add(hosts.getName());
        }
        return new Play(this.handlers, linkedList.toArray(new String[linkedList.size()]), this.name, this.roles, this.tasks);
    }

    public Play roles(Role ... roleArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Role role : roleArray) {
            linkedList.add(role.getName());
        }
        return new Play(this.handlers, this.hosts, this.name, linkedList.toArray(new String[linkedList.size()]), this.tasks);
    }

    public Play tasks(Task ... taskArray) {
        return new Play(this.handlers, this.hosts, this.name, this.roles, ArraysHelper.copyIfNotEmpty(taskArray));
    }

    public Handler[] getHandlers() {
        return ArraysHelper.copyIfNotEmpty(this.handlers);
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public String getName() {
        return this.name;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public Task[] getTasks() {
        return ArraysHelper.copyIfNotEmpty(this.tasks);
    }
}

