/*
 * Decompiled with CFR 0.152.
 */
package eu.tznvy.jancy.core;

import eu.tznvy.jancy.core.ArraysHelper;
import eu.tznvy.jancy.core.Group;
import eu.tznvy.jancy.core.Host;
import java.util.HashMap;
import java.util.Map;

public class Inventory {
    private final Host[] hosts;
    private final Group[] groups;
    private final String name;
    private final Map<String, Object> vars;

    public Inventory(String string) {
        this.hosts = new Host[0];
        this.groups = new Group[0];
        this.name = string;
        this.vars = new HashMap<String, Object>();
    }

    private Inventory(Host[] hostArray, Group[] groupArray, String string, Map<String, Object> map) {
        this.hosts = hostArray;
        this.groups = groupArray;
        this.name = string;
        this.vars = map;
    }

    public Inventory hosts(Host ... hostArray) {
        return new Inventory(ArraysHelper.copyIfNotEmpty(hostArray), this.groups, this.name, this.vars);
    }

    public Inventory groups(Group ... groupArray) {
        return new Inventory(this.hosts, ArraysHelper.copyIfNotEmpty(groupArray), this.name, this.vars);
    }

    public Inventory vars(Map<String, Object> map) {
        return new Inventory(this.hosts, this.groups, this.name, new HashMap<String, Object>(map));
    }

    public Group[] getGroups() {
        return ArraysHelper.copyIfNotEmpty(this.groups);
    }

    public Host[] getHosts() {
        return ArraysHelper.copyIfNotEmpty(this.hosts);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getVars() {
        return new HashMap<String, Object>(this.vars);
    }
}

